import { StyleSheet, View } from 'react-native';
import React from 'react';
import SkeletonElement from '../../SkeletonElement';
import dpr from '../../../../screens/Utilities/CustomStyleAttribute/dpr';

const ProductItemOwnerSkeleton = () => {
    return (
        <View style={styles.cont}>
            <View>
                <SkeletonElement
                    wrapperStyle={styles.skeletonWrapper(10, 100)}
                />
                <SkeletonElement
                    wrapperStyle={styles.skeletonWrapper(20, 200)}
                />
                <SkeletonElement
                    wrapperStyle={styles.skeletonWrapper(20, 200)}
                />
            </View>
            <SkeletonElement
                wrapperStyle={styles.skeletonWrapper(80, 80)}
            />
        </View>
    );
};

export default ProductItemOwnerSkeleton;

const styles = StyleSheet.create({
    cont: {
        width: dpr('wf') - dpr(80),
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
    },
    skeletonWrapper: (height, width) => ({
        height: dpr(height),
        width: dpr(width),
    }),
});
